/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.TeardownCallsSuperTeardownInspection;
import org.jetbrains.annotations.NotNull;

public class SetupCallsSuperSetupInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SetUpDoesntCallSuperSetUp";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("setup.calls.super.setup.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("setup.calls.super.setup.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSuperSetUpCall();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TeardownCallsSuperTeardownInspection.TeardownCallsSuperTeardownVisitor("setUp");
    }

    private static class AddSuperSetUpCall
    extends InspectionGadgetsFix {
        private AddSuperSetUpCall() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("setup.calls.super.setup.add.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            assert (method != null);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiStatement newStatement = factory.createStatementFromText("super.setUp();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
            PsiJavaToken brace = body.getLBrace();
            body.addAfter((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body);
        }
    }
}

