/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ParameterizedParametersStaticCollectionInspectionBase
extends BaseInspection {
    protected static final String PARAMETERS_FQN = "org.junit.runners.Parameterized.Parameters";
    private static final String PARAMETERIZED_FQN = "org.junit.runners.Parameterized";

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return infos.length > 0 ? (String)infos[1] : "Class #ref annotated @RunWith(Parameterized.class) lacks data provider";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitClass(PsiClass aClass) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"org.junit.runner.RunWith"});
                if (annotation != null) {
                    for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                        PsiTypeElement typeElement;
                        PsiAnnotationMemberValue value = pair.getValue();
                        if (!(value instanceof PsiClassObjectAccessExpression) || !(typeElement = ((PsiClassObjectAccessExpression)value).getOperand()).getType().getCanonicalText().equals(ParameterizedParametersStaticCollectionInspectionBase.PARAMETERIZED_FQN)) continue;
                        ArrayList<MethodCandidate> candidates = new ArrayList<MethodCandidate>();
                        for (PsiMethod method : aClass.getMethods()) {
                            PsiType returnType = method.getReturnType();
                            PsiClass returnTypeClass = PsiUtil.resolveClassInType((PsiType)returnType);
                            Project project2 = aClass.getProject();
                            PsiClass collectionsClass = JavaPsiFacade.getInstance((Project)project2).findClass(Collection.class.getName(), GlobalSearchScope.allScope((Project)project2));
                            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)ParameterizedParametersStaticCollectionInspectionBase.PARAMETERS_FQN, (boolean)false)) continue;
                            PsiModifierList modifierList = method.getModifierList();
                            boolean hasToFixSignature = false;
                            String message = "Make method '" + method.getName() + "' ";
                            String errorString = "Method '#ref()' should be ";
                            if (!modifierList.hasModifierProperty("public")) {
                                message = message + "public ";
                                errorString = errorString + "public ";
                                hasToFixSignature = true;
                            }
                            if (!modifierList.hasModifierProperty("static")) {
                                message = message + "static";
                                errorString = errorString + "static";
                                hasToFixSignature = true;
                            }
                            if (!(collectionsClass == null || returnTypeClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)returnTypeClass, (PsiClass)collectionsClass, (boolean)true))) {
                                message = message + (hasToFixSignature ? " and" : "") + " return Collection";
                                errorString = errorString + (hasToFixSignature ? " and" : "") + " return Collection";
                                returnType = JavaPsiFacade.getElementFactory((Project)project2).createType(collectionsClass);
                                hasToFixSignature = true;
                            }
                            if (hasToFixSignature) {
                                candidates.add(new MethodCandidate(method, message, errorString, returnType));
                                continue;
                            }
                            return;
                        }
                        if (candidates.isEmpty()) {
                            this.registerClassError(aClass, new Object[0]);
                            continue;
                        }
                        for (MethodCandidate candidate : candidates) {
                            this.registerMethodError(candidate.myMethod, candidate.myProblem, candidate.myErrorString, candidate.myReturnType);
                        }
                    }
                }
            }
        };
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "@RunWith(Parameterized.class) without data provider";
    }

    private static class MethodCandidate {
        PsiMethod myMethod;
        String myProblem;
        private final String myErrorString;
        PsiType myReturnType;

        public MethodCandidate(PsiMethod method, String problem, String errorString, PsiType returnType) {
            this.myMethod = method;
            this.myProblem = problem;
            this.myErrorString = errorString;
            this.myReturnType = returnType;
        }
    }
}

