/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MisspelledSetUpInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("misspelled.set.up.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("misspelled.set.up.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MisspelledSetUpVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static class MisspelledSetUpVisitor
    extends BaseInspectionVisitor {
        private MisspelledSetUpVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass aClass = method.getContainingClass();
            String methodName = method.getName();
            if (!"setup".equals(methodName)) {
                return;
            }
            if (aClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

