/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class MakePublicStaticFix
extends InspectionGadgetsFix {
    private final String myName;
    private final boolean myMakeStatic;

    public MakePublicStaticFix(String name, boolean makeStatic) {
        this.myName = name;
        this.myMakeStatic = makeStatic;
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement element = descriptor.getPsiElement();
        if (element != null && (parent = element.getParent()) instanceof PsiMember) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiMember)parent), (String)"public", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiMember)parent), (String)"static", (boolean)this.myMakeStatic);
        }
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        return "Make public/static";
    }
}

