/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class JUnitTestClassNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("junit.test.class.naming.convention.display.name", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("junit.test.class.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*Test";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (!(element instanceof PsiClass)) {
                super.visitElement(element);
                return;
            }
            PsiClass aClass = (PsiClass)element;
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase") && !this.hasJUnit4TestMethods(aClass)) {
                return;
            }
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (JUnitTestClassNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }

        private boolean hasJUnit4TestMethods(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!TestUtils.isJUnit4TestMethod(method)) continue;
                return true;
            }
            return false;
        }
    }
}

