/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.JUnitRuleInspection;
import com.siyeh.ig.junit.MakePublicStaticFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitDatapointInspection
extends BaseInspection {
    public static final String DATAPOINT_FQN = "org.junit.experimental.theories.DataPoint";

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("junit.datapoint.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return (String)infos[0];
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return infos.length > 1 ? new MakePublicStaticFix((String)infos[1], true) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitMethod(PsiMethod method) {
                this.visitMember(method, "method");
            }

            public void visitField(PsiField field) {
                this.visitMember(field, "field");
            }

            private <T extends PsiMember & PsiNameIdentifierOwner> void visitMember(T member, String memberDescription) {
                String errorMessage;
                boolean dataPointAnnotated = AnnotationUtil.isAnnotated(member, (String)JUnitDatapointInspection.DATAPOINT_FQN, (boolean)false);
                if (dataPointAnnotated && (errorMessage = JUnitRuleInspection.getPublicStaticErrorMessage(member, false, true)) != null) {
                    PsiElement identifier = ((PsiNameIdentifierOwner)member).getNameIdentifier();
                    this.registerError((PsiElement)(identifier != null ? identifier : member), InspectionGadgetsBundle.message("junit.datapoint.problem.descriptor", errorMessage, StringUtil.capitalize((String)memberDescription)), "Make " + memberDescription + " " + errorMessage, JUnitDatapointInspection.DATAPOINT_FQN);
                }
            }
        };
    }
}

