/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit4MethodNamingConventionInspectionBase
extends ConventionInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("junit4.method.naming.convention.display.name", new Object[0]);
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("junit4.method.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z_\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JUnit4MethodNamingConventionVisitor();
    }

    private class JUnit4MethodNamingConventionVisitor
    extends BaseInspectionVisitor {
        private JUnit4MethodNamingConventionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!TestUtils.isJUnit4TestMethod(method) || !TestUtils.isRunnable(method)) {
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            String name = method.getName();
            if (JUnit4MethodNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            if (!this.isOnTheFly() && MethodUtils.hasSuper(method)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, name);
        }
    }
}

