/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsCalledOnArrayInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assertequals.called.on.arrays.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("assertequals.called.on.arrays.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssertEqualsCalledOnArrayFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsOnArrayVisitor();
    }

    private static class AssertEqualsOnArrayVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsOnArrayVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiType type2;
            PsiExpression argument1;
            PsiType type1;
            PsiExpression argument0;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"assertEquals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 2) {
                argument0 = arguments[0];
                type1 = argument0.getType();
                argument1 = arguments[1];
                type2 = argument1.getType();
            } else if (arguments.length == 3) {
                argument0 = arguments[1];
                type1 = argument0.getType();
                argument1 = arguments[2];
                type2 = argument1.getType();
            } else {
                return;
            }
            if (!(type1 instanceof PsiArrayType) || !(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!(InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.Assert") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.testng.AssertJUnit"))) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class AssertEqualsCalledOnArrayFix
    extends InspectionGadgetsFix {
        private AssertEqualsCalledOnArrayFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("assertequals.called.on.arrays.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null && ImportUtils.addStaticImport("org.junit.Assert", "assertArrayEquals", (PsiElement)methodExpression)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, "assertArrayEquals");
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, "org.junit.Assert.assertArrayEquals");
            }
        }
    }
}

