/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.j2me.VariableAccessVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FieldRepeatedlyAccessedInspection
extends BaseInspection {
    public boolean m_ignoreFinalFields = false;

    @NotNull
    public String getID() {
        return "FieldRepeatedlyAccessedInMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("field.repeatedly.accessed.in.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... arg) {
        String fieldName = ((PsiNamedElement)arg[0]).getName();
        return InspectionGadgetsBundle.message("field.repeatedly.accessed.in.method.problem.descriptor", fieldName);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("field.repeatedly.accessed.in.method.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreFinalFields");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldRepeatedlyAccessedVisitor();
    }

    private class FieldRepeatedlyAccessedVisitor
    extends BaseInspectionVisitor {
        private FieldRepeatedlyAccessedVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            VariableAccessVisitor visitor = new VariableAccessVisitor();
            method.accept((PsiElementVisitor)visitor);
            Set<PsiField> fields = visitor.getOveraccessedFields();
            for (PsiField field : fields) {
                if (ExpressionUtils.isConstant(field) || FieldRepeatedlyAccessedInspection.this.m_ignoreFinalFields && field.hasModifierProperty("final")) continue;
                this.registerError((PsiElement)nameIdentifier, field);
            }
        }
    }
}

