/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnicodeEscapeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.unicode.escape.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Character c = (Character)infos[0];
        return InspectionGadgetsBundle.message("unnecessary.unicode.escape.problem.descriptor", c);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnicodeEscapeFix(((Character)infos[0]).charValue());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnicodeEscapeVisitor();
    }

    private class UnnecessaryUnicodeEscapeVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnicodeEscapeVisitor() {
        }

        public void visitFile(PsiFile file2) {
            super.visitFile(file2);
            if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2) || !file2.isPhysical()) {
                return;
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            String text = file2.getText();
            Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text);
            CharsetEncoder encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer charBuffer = CharBuffer.allocate(1);
            ByteBuffer byteBuffer = ByteBuffer.allocate(10);
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                int escapeEnd;
                char d;
                char c = text.charAt(i);
                if (c != '\\') continue;
                boolean isEscape = true;
                for (int previousChar = i - 1; previousChar >= 0 && text.charAt(previousChar) == '\\'; --previousChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape) continue;
                int nextChar = i;
                while (++nextChar < length && text.charAt(nextChar) == 'u') {
                }
                if (nextChar == i + 1 || nextChar + 3 >= length || !StringUtil.isHexDigit((char)text.charAt(nextChar)) || !StringUtil.isHexDigit((char)text.charAt(nextChar + 1)) || !StringUtil.isHexDigit((char)text.charAt(nextChar + 2)) || !StringUtil.isHexDigit((char)text.charAt(nextChar + 3)) || Character.isISOControl(d = (char)Integer.parseInt(text.substring(nextChar, escapeEnd = nextChar + 4), 16))) continue;
                byteBuffer.clear();
                charBuffer.clear();
                charBuffer.put(d).rewind();
                CoderResult coderResult = encoder.encode(charBuffer, byteBuffer, true);
                if (coderResult.isError()) continue;
                PsiElement element = file2.findElementAt(i);
                if (element != null && UnnecessaryUnicodeEscapeInspection.this.isSuppressedFor(element)) {
                    return;
                }
                this.registerErrorAtOffset((PsiElement)file2, i, escapeEnd - i, Character.valueOf(d));
            }
        }
    }

    private static class UnnecessaryUnicodeEscapeFix
    extends InspectionGadgetsFix {
        private final char c;

        public UnnecessaryUnicodeEscapeFix(char c) {
            this.c = c;
        }

        @NotNull
        public String getName() {
            return "Replace with '" + this.c + "'";
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with character";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            TextRange textRange = descriptor.getTextRangeInElement();
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiFile)) {
                return;
            }
            PsiFile file2 = (PsiFile)element;
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
            if (document == null) {
                return;
            }
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)String.valueOf(this.c));
        }
    }
}

