/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeInitializerExplicitFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableInitializationInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        return "StaticVariableMayNotBeInitialized";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("static.variable.may.not.be.initialized.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("static.variable.may.not.be.initialized.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignorePrimitives");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeInitializerExplicitFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableInitializationVisitor();
    }

    private class StaticVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private StaticVariableInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClassInitializer[] initializers;
            PsiType type;
            if (!field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || containingClass.isEnum()) {
                return;
            }
            if (StaticVariableInitializationInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(type = field.getType())) {
                return;
            }
            for (PsiClassInitializer initializer : initializers = containingClass.getInitializers()) {
                PsiCodeBlock body;
                if (!initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), (PsiVariable)field)) continue;
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

