/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class OverriddenMethodCallDuringObjectConstructionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("overridden.method.call.in.constructor.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("overridden.method.call.in.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverriddenMethodCallInConstructorVisitor();
    }

    private static class OverriddenMethodCallInConstructorVisitor
    extends BaseInspectionVisitor {
        private OverriddenMethodCallInConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethod containingMethod;
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallDuringObjectConstruction(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
            if (containingClass == null || containingClass.hasModifierProperty("final")) {
                return;
            }
            PsiMethod calledMethod = expression.resolveMethod();
            if (calledMethod == null || !PsiUtil.canBeOverriden((PsiMethod)calledMethod)) {
                return;
            }
            PsiClass calledMethodClass = calledMethod.getContainingClass();
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)calledMethodClass, (boolean)true)) {
                return;
            }
            if (!MethodUtils.isOverriddenInHierarchy(calledMethod, containingClass)) {
                return;
            }
            if (CloneUtils.isClone(calledMethod) && CloneUtils.isClone(containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class))) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

