/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.initialization.NonThreadSafeLazyInitializationInspectionBase;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonThreadSafeLazyInitializationInspection
extends NonThreadSafeLazyInitializationInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiIfStatement ifStatement = (PsiIfStatement)infos[0];
        PsiField field = (PsiField)infos[1];
        if (!NonThreadSafeLazyInitializationInspection.isStaticAndAssignedOnce(field) || !NonThreadSafeLazyInitializationInspection.isSafeToDeleteIfStatement(ifStatement, field)) {
            return null;
        }
        return new IntroduceHolderFix();
    }

    private static boolean isStaticAndAssignedOnce(PsiField field) {
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        final int[] writeCount = new int[1];
        return ReferencesSearch.search((PsiElement)field).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                    return true;
                }
                writeCount[0] = writeCount[0] + 1;
                return writeCount[0] != 2;
            }
        });
    }

    private static boolean isSafeToDeleteIfStatement(PsiIfStatement ifStatement, PsiField field) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch == null) {
            return false;
        }
        PsiStatement statement2 = ControlFlowUtils.stripBraces(thenBranch);
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        return NonThreadSafeLazyInitializationInspection.isSimpleAssignment(expressionStatement, field);
    }

    private static boolean isSimpleAssignment(PsiExpressionStatement expressionStatement, PsiField field) {
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
        PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
        if (!(lhs instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
        PsiElement target = referenceExpression.resolve();
        if (!field.equals(target)) {
            return false;
        }
        Collection referenceChildren = PsiTreeUtil.findChildrenOfType((PsiElement)assignmentExpression.getRExpression(), PsiReferenceExpression.class);
        for (PsiReferenceExpression child : referenceChildren) {
            PsiElement target2 = child.resolve();
            if (!(target2 instanceof PsiMember)) {
                return false;
            }
            PsiMember member = (PsiMember)target2;
            if (member.hasModifierProperty("static")) continue;
            return false;
        }
        return true;
    }

    private static class IntroduceHolderFix
    extends InspectionGadgetsFix {
        private IntroduceHolderFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiReferenceExpression expression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiElement resolved = expression.resolve();
            if (!(resolved instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)resolved;
            String holderName = StringUtil.capitalize((String)field.getName()) + "Holder";
            PsiElement expressionParent = expression.getParent();
            if (!(expressionParent instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expressionParent;
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            String text = "private static class " + holderName + " {" + "private static final " + field.getType().getCanonicalText() + " " + field.getName() + " = " + rhs.getText() + ";}";
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)field.getProject());
            PsiClass holder = elementFactory.createClassFromText(text, (PsiElement)field).getInnerClasses()[0];
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiClass holderClass = (PsiClass)method.getParent().addBefore((PsiElement)holder, (PsiElement)method);
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            if (ifStatement != null) {
                ifStatement.delete();
            }
            PsiExpression holderReference = elementFactory.createExpressionFromText(holderName + "." + field.getName(), (PsiElement)field);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)field).findAll()) {
                reference.getElement().replace((PsiElement)holderReference);
            }
            field.delete();
            if (!this.isOnTheFly()) {
                return;
            }
            IntroduceHolderFix.invokeInplaceRename((PsiNameIdentifierOwner)holderClass, holderName, IntroduceHolderFix.suggestHolderName(field));
        }

        private static void invokeInplaceRename(PsiNameIdentifierOwner nameIdentifierOwner, final String ... suggestedNames) {
            final PsiNameIdentifierOwner elementToRename = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(nameIdentifierOwner);
            final Editor editor = FileEditorManager.getInstance((Project)nameIdentifierOwner.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            PsiElement identifier = elementToRename.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(identifier.getTextOffset());
            RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement((PsiElement)elementToRename);
            if (!processor2.isInplaceRenameSupported()) {
                return;
            }
            processor2.substituteElementToRename((PsiElement)elementToRename, editor, new Pass<PsiElement>(){

                public void pass(PsiElement substitutedElement) {
                    MemberInplaceRenamer renamer = new MemberInplaceRenamer((PsiNamedElement)elementToRename, substitutedElement, editor);
                    LinkedHashSet<String> nameSuggestions = new LinkedHashSet<String>(Arrays.asList(suggestedNames));
                    renamer.performInplaceRefactoring(nameSuggestions);
                }
            });
        }

        @NonNls
        private static String suggestHolderName(PsiField field) {
            String string = field.getType().getDeepComponentType().getPresentableText();
            int index = string.indexOf(60);
            if (index != -1) {
                string = string.substring(0, index);
            }
            return string + "Holder";
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("introduce.holder.class.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }
    }
}

