/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspectionBase
extends BaseInspection {
    public boolean ignoreEmptySuperMethods;
    final ExternalizableStringSet annotations = new ExternalizableStringSet("javax.annotation.OverridingMethodsMustInvokeSuper");
    boolean onlyReportWhenAnnotated = true;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        super.writeSettings(node);
        if (this.onlyReportWhenAnnotated) {
            node.addContent(new Element("option").setAttribute("name", "onlyReportWhenAnnotated").setAttribute("value", String.valueOf(this.onlyReportWhenAnnotated)));
        }
        if (!this.annotations.hasDefaultValues()) {
            Element element = new Element("option").setAttribute("name", "annotations");
            Element valueElement = new Element("value");
            this.annotations.writeExternal(valueElement);
            node.addContent(element.addContent(valueElement));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        super.readSettings(node);
        this.onlyReportWhenAnnotated = false;
        for (Element option : node.getChildren("option")) {
            Element value;
            if ("onlyReportWhenAnnotated".equals(option.getAttributeValue("name"))) {
                this.onlyReportWhenAnnotated = Boolean.parseBoolean(option.getAttributeValue("value"));
                continue;
            }
            if (!"annotations".equals(option.getAttributeValue("name")) || (value = option.getChild("value")) == null) continue;
            this.annotations.readExternal(value);
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("refused.bequest.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("refused.bequest.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RefusedBequestVisitor();
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMethod methodToSearchFor;
        private boolean hasSuperCall;

        SuperCallVisitor(PsiMethod methodToSearchFor) {
            this.methodToSearchFor = methodToSearchFor;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.hasSuperCall) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (this.hasSuperCall) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String text = qualifier.getText();
            if (!"super".equals(text)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (method.equals(this.methodToSearchFor)) {
                this.hasSuperCall = true;
            }
        }

        boolean hasSuperCall() {
            return this.hasSuperCall;
        }
    }

    private class RefusedBequestVisitor
    extends BaseInspectionVisitor {
        private RefusedBequestVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            super.visitMethod(method);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod leastConcreteSuperMethod = this.getDirectSuperMethod(method);
            if (leastConcreteSuperMethod == null) {
                return;
            }
            PsiClass objectClass = ClassUtils.findObjectClass((PsiElement)method);
            PsiMethod[] superMethods = method.findSuperMethods(objectClass);
            if (superMethods.length > 0) {
                return;
            }
            if (RefusedBequestInspectionBase.this.ignoreEmptySuperMethods) {
                PsiMethod superMethod;
                PsiElement element = leastConcreteSuperMethod.getNavigationElement();
                PsiMethod psiMethod = superMethod = element instanceof PsiMethod ? (PsiMethod)element : leastConcreteSuperMethod;
                if (MethodUtils.isTrivial(superMethod, true)) {
                    return;
                }
            }
            if (RefusedBequestInspectionBase.this.onlyReportWhenAnnotated && !AnnotationUtil.isAnnotated((PsiModifierListOwner)leastConcreteSuperMethod, (Collection)((Object)RefusedBequestInspectionBase.this.annotations))) {
                return;
            }
            if (this.containsSuperCall((PsiElement)body, leastConcreteSuperMethod)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        @Nullable
        private PsiMethod getDirectSuperMethod(PsiMethod method) {
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null || superMethod.hasModifierProperty("abstract")) {
                return null;
            }
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass == null || containingClass.isInterface()) {
                return null;
            }
            return superMethod;
        }

        private boolean containsSuperCall(@NotNull PsiElement context, @NotNull PsiMethod method) {
            SuperCallVisitor visitor = new SuperCallVisitor(method);
            context.accept((PsiElementVisitor)visitor);
            return visitor.hasSuperCall();
        }
    }
}

