/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantMethodOverrideInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("redundant.method.override.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("redundant.method.override.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantMethodOverrideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantMethodOverrideVisitor();
    }

    private static class RedundantMethodOverrideVisitor
    extends BaseInspectionVisitor {
        private RedundantMethodOverrideVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null) {
                return;
            }
            PsiCodeBlock superBody = superMethod.getBody();
            if (superBody == null) {
                return;
            }
            if (!RedundantMethodOverrideVisitor.modifierListsAreEquivalent(method.getModifierList(), superMethod.getModifierList())) {
                return;
            }
            PsiType superReturnType = superMethod.getReturnType();
            if (superReturnType == null || !superReturnType.equals(method.getReturnType())) {
                return;
            }
            if (!EquivalenceChecker.codeBlocksAreEquivalent(body, superBody)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean modifierListsAreEquivalent(@Nullable PsiModifierList list1, @Nullable PsiModifierList list2) {
            if (list1 == null) {
                return list2 == null;
            }
            if (list2 == null) {
                return false;
            }
            HashSet<String> annotations1 = new HashSet<String>();
            for (PsiAnnotation annotation : list1.getAnnotations()) {
                annotations1.add(annotation.getQualifiedName());
            }
            HashSet<String> annotations2 = new HashSet<String>();
            for (PsiAnnotation annotation : list2.getAnnotations()) {
                annotations2.add(annotation.getQualifiedName());
            }
            Set uniques = RedundantMethodOverrideVisitor.disjunction(annotations1, annotations2);
            uniques.remove("java.lang.Override");
            if (!uniques.isEmpty()) {
                return false;
            }
            return list1.hasModifierProperty("strictfp") == list2.hasModifierProperty("strictfp") && list1.hasModifierProperty("synchronized") == list2.hasModifierProperty("synchronized") && list1.hasModifierProperty("public") == list2.hasModifierProperty("public") && list1.hasModifierProperty("protected") == list2.hasModifierProperty("protected");
        }

        private static <T> Set<T> disjunction(Collection<T> set1, Collection<T> set2) {
            HashSet<T> result = new HashSet<T>();
            for (T t : set1) {
                if (set2.contains(t)) continue;
                result.add(t);
            }
            for (T t : set2) {
                if (set1.contains(t)) continue;
                result.add(t);
            }
            return result;
        }
    }

    private static class RedundantMethodOverrideFix
    extends InspectionGadgetsFix {
        private RedundantMethodOverrideFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("redundant.method.override.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            RedundantMethodOverrideFix.deleteElement(method);
        }
    }
}

