/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.imports.ImportsAreUsedVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedImportInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unused.import.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unused.import.problem.descriptor", new Object[0]);
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedImportVisitor();
    }

    private static class UnusedImportVisitor
    extends BaseInspectionVisitor {
        private UnusedImportVisitor() {
        }

        public void visitJavaFile(PsiJavaFile file2) {
            PsiClass[] classes = file2.getClasses();
            PsiPackageStatement packageStatement = file2.getPackageStatement();
            PsiModifierList annotationList = packageStatement != null ? packageStatement.getAnnotationList() : null;
            this.checkImports(file2, classes, annotationList);
        }

        private void checkImports(PsiJavaFile file2, PsiClass[] classes, @Nullable PsiModifierList annotationList) {
            ImportsAreUsedVisitor visitor = new ImportsAreUsedVisitor(file2);
            for (PsiClass psiClass : classes) {
                psiClass.accept((PsiElementVisitor)visitor);
            }
            if (annotationList != null) {
                annotationList.accept((PsiElementVisitor)visitor);
            }
            for (PsiClass psiClass : visitor.getUnusedImportStatements()) {
                this.registerError((PsiElement)psiClass, new Object[0]);
            }
        }
    }
}

