/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressForTestsScopeFix
extends InspectionGadgetsFix {
    private final BaseInspection myInspection;

    private SuppressForTestsScopeFix(BaseInspection inspection) {
        this.myInspection = inspection;
    }

    @Nullable
    public static SuppressForTestsScopeFix build(BaseInspection inspection, PsiElement context) {
        if (!TestUtils.isInTestSourceContent(context)) {
            return null;
        }
        return new SuppressForTestsScopeFix(inspection);
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("suppress.for.tests.scope.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @Override
    protected boolean prepareForWriting() {
        return false;
    }

    @Override
    protected void doFix(final Project project2, ProblemDescriptor descriptor) {
        this.addRemoveTestsScope(project2, true);
        VirtualFile vFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
        UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

            public void undo() throws UnexpectedUndoException {
                SuppressForTestsScopeFix.this.addRemoveTestsScope(project2, false);
            }

            public void redo() throws UnexpectedUndoException {
                SuppressForTestsScopeFix.this.addRemoveTestsScope(project2, true);
            }
        });
    }

    private void addRemoveTestsScope(Project project2, boolean add) {
        String shortName;
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl profile = (InspectionProfileImpl)profileManager.getInspectionProfile();
        InspectionToolWrapper tool = profile.getInspectionTool(shortName = this.myInspection.getShortName(), project2);
        if (tool == null) {
            return;
        }
        if (add) {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)project2, (String)"Tests");
            HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
            HighlightDisplayLevel level = profile.getErrorLevel(key, namedScope, project2);
            profile.addScope(tool, namedScope, level, false, project2);
        } else {
            profile.removeScope(shortName, "Tests", project2);
        }
        profile.scopesChanged();
    }
}

