/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ReplaceInheritanceWithDelegationFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("replace.inheritance.with.delegation.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @Override
    public void doFix(final @NotNull Project project2, ProblemDescriptor descriptor) {
        PsiElement nameElement = descriptor.getPsiElement();
        final PsiClass aClass = (PsiClass)nameElement.getParent();
        assert (!(aClass instanceof PsiAnonymousClass));
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        final RefactoringActionHandler anonymousToInner = factory.createInheritanceToDelegationHandler();
        DataManager dataManager = DataManager.getInstance();
        final DataContext dataContext = dataManager.getDataContext();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                anonymousToInner.invoke(project2, new PsiElement[]{aClass}, dataContext);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2, project2.getDisposed());
        }
    }
}

