/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.util.Consumer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameFix
extends InspectionGadgetsFix {
    private final String m_targetName;
    private boolean m_searchInStrings = true;
    private boolean m_searchInNonJavaFiles = true;

    public RenameFix() {
        this.m_targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.m_targetName = targetName;
    }

    public RenameFix(@NonNls String targetName, boolean searchInStrings, boolean searchInNonJavaFiles) {
        this.m_targetName = targetName;
        this.m_searchInStrings = searchInStrings;
        this.m_searchInNonJavaFiles = searchInNonJavaFiles;
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("rename.quickfix", new Object[0]);
    }

    @NotNull
    public String getName() {
        if (this.m_targetName == null) {
            return InspectionGadgetsBundle.message("rename.quickfix", new Object[0]);
        }
        return InspectionGadgetsBundle.message("renameto.quickfix", this.m_targetName);
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    @Override
    public void doFix(final Project project2, ProblemDescriptor descriptor) {
        PsiElement nameIdentifier = descriptor.getPsiElement();
        final PsiElement elementToRename = nameIdentifier.getParent();
        if (this.m_targetName == null) {
            AsyncResult contextFromFocus = DataManager.getInstance().getDataContextFromFocus();
            contextFromFocus.doWhenDone((Consumer)new Consumer<DataContext>(){

                public void consume(DataContext context) {
                    RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context);
                    if (renameHandler == null) {
                        return;
                    }
                    renameHandler.invoke(project2, new PsiElement[]{elementToRename}, context);
                }
            });
        } else {
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project2);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.m_targetName, this.m_searchInStrings, this.m_searchInNonJavaFiles);
            renameRefactoring.run();
        }
    }
}

