/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class MoveClassFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("move.class.quickfix", new Object[0]);
    }

    @Override
    public void doFix(final @NotNull Project project2, ProblemDescriptor descriptor) {
        PsiElement nameElement = descriptor.getPsiElement();
        final PsiClass aClass = (PsiClass)nameElement.getParent();
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                RefactoringActionHandlerFactory factory = RefactoringActionHandlerFactory.getInstance();
                RefactoringActionHandler moveHandler = factory.createMoveHandler();
                DataManager dataManager = DataManager.getInstance();
                DataContext dataContext = dataManager.getDataContext();
                moveHandler.invoke(project2, new PsiElement[]{aClass}, dataContext);
            }
        });
    }
}

