/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MakeInitializerExplicitFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("make.initialization.explicit.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @Override
    public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement fieldName = descriptor.getPsiElement();
        PsiElement parent = fieldName.getParent();
        if (!(parent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        if (field.getInitializer() != null) {
            return;
        }
        PsiType type = field.getType();
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(MakeInitializerExplicitFix.getDefaultValue(type), (PsiElement)field);
        field.setInitializer(initializer);
    }

    @NonNls
    private static String getDefaultValue(PsiType type) {
        if (PsiType.INT.equals((Object)type)) {
            return "0";
        }
        if (PsiType.LONG.equals((Object)type)) {
            return "0L";
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            return "0.0";
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            return "0.0F";
        }
        if (PsiType.SHORT.equals((Object)type)) {
            return "(short)0";
        }
        if (PsiType.BYTE.equals((Object)type)) {
            return "(byte)0";
        }
        if (PsiType.BOOLEAN.equals((Object)type)) {
            return "false";
        }
        if (PsiType.CHAR.equals((Object)type)) {
            return "(char)0";
        }
        return "null";
    }
}

