/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class IntroduceConstantFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("introduce.constant.quickfix", new Object[0]);
    }

    @Override
    public void doFix(final @NotNull Project project2, ProblemDescriptor descriptor) {
        final PsiElement constant = descriptor.getPsiElement();
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!constant.isValid()) {
                    return;
                }
                JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
                RefactoringActionHandler introduceHandler = factory.createIntroduceConstantHandler();
                DataManager dataManager = DataManager.getInstance();
                DataContext dataContext = dataManager.getDataContext();
                introduceHandler.invoke(project2, new PsiElement[]{constant}, dataContext);
            }
        }, project2.getDisposed());
    }
}

