/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class InlineCallFix
extends InspectionGadgetsFix {
    private final String myName;

    public InlineCallFix(String name) {
        this.myName = name;
    }

    public InlineCallFix() {
        this(InspectionGadgetsBundle.message("inline.call.quickfix", new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        return this.myName;
    }

    @NotNull
    public String getName() {
        return this.getFamilyName();
    }

    @Override
    public void doFix(Project project2, ProblemDescriptor descriptor) {
        PsiElement nameElement = descriptor.getPsiElement();
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)nameElement.getParent();
        if (methodExpression == null) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        this.inline(project2, methodExpression, method);
    }

    protected void inline(Project project2, PsiReferenceExpression methodExpression, PsiMethod method) {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        InlineMethodProcessor processor2 = new InlineMethodProcessor(project2, method, (PsiJavaCodeReferenceElement)methodExpression, null, true, settings.RENAME_SEARCH_IN_COMMENTS_FOR_METHOD, settings.RENAME_SEARCH_FOR_TEXT_FOR_METHOD);
        processor2.inlineMethodCall(processor2.addBracesWhenNeeded(new PsiReferenceExpression[]{methodExpression})[0]);
    }
}

