/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("extract.method.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @Override
    public void doFix(final Project project2, ProblemDescriptor descriptor) {
        final PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        final RefactoringActionHandler extractHandler = factory.createExtractMethodHandler();
        DataManager dataManager = DataManager.getInstance();
        final DataContext dataContext = dataManager.getDataContext();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                extractHandler.invoke(project2, new PsiElement[]{expression}, dataContext);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }
}

