/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ConvertToVarargsMethodFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("convert.to.variable.arity.method.quickfix", new Object[0]);
    }

    @Override
    protected boolean prepareForWriting() {
        return false;
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)parent;
        ArrayList<Object> writtenElements = new ArrayList<Object>();
        ArrayList<PsiReferenceExpression> methodCalls = new ArrayList<PsiReferenceExpression>();
        writtenElements.add(method);
        for (PsiReference reference : ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope(), (boolean)false)) {
            PsiElement referenceElement = reference.getElement();
            if (!(referenceElement instanceof PsiReferenceExpression)) continue;
            writtenElements.add(referenceElement);
            methodCalls.add((PsiReferenceExpression)referenceElement);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(writtenElements)) {
            return;
        }
        ConvertToVarargsMethodFix.makeMethodVarargs(method);
        ConvertToVarargsMethodFix.makeMethodCallsVarargs(methodCalls);
    }

    private static void makeMethodVarargs(PsiMethod method) {
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 0) {
            return;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        PsiParameter lastParameter = parameters[parameters.length - 1];
        PsiType type = lastParameter.getType();
        if (!(type instanceof PsiArrayType)) {
            return;
        }
        PsiArrayType arrayType = (PsiArrayType)type;
        PsiType componentType = arrayType.getComponentType();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiType ellipsisType = PsiEllipsisType.createEllipsis((PsiType)componentType, (PsiAnnotation[])type.getAnnotations());
        PsiTypeElement newTypeElement = factory.createTypeElement(ellipsisType);
        PsiTypeElement typeElement = lastParameter.getTypeElement();
        if (typeElement != null) {
            typeElement.replace((PsiElement)newTypeElement);
        }
    }

    private static void makeMethodCallsVarargs(Collection<PsiReferenceExpression> referenceExpressions) {
        for (PsiReferenceExpression referenceExpression : referenceExpressions) {
            PsiExpression[] initializers;
            PsiNewExpression newExpression;
            PsiArrayInitializerExpression arrayInitializerExpression;
            PsiExpression lastArgument;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)referenceExpression.getParent();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0 || !((lastArgument = arguments[arguments.length - 1]) instanceof PsiNewExpression) || (arrayInitializerExpression = (newExpression = (PsiNewExpression)lastArgument).getArrayInitializer()) == null) continue;
            for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
                argumentList.add((PsiElement)initializer);
            }
            lastArgument.delete();
        }
    }
}

