/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SerialVersionUIDBuilder;
import org.jetbrains.annotations.NotNull;

public class AddSerialVersionUIDFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("add.serialversionuidfield.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @Override
    public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement classIdentifier = descriptor.getPsiElement();
        PsiClass aClass = (PsiClass)classIdentifier.getParent();
        assert (aClass != null);
        PsiManager psiManager = aClass.getManager();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        long serialVersionUID = SerialVersionUIDBuilder.computeDefaultSUID(aClass);
        PsiField field = elementFactory.createFieldFromText("private static final long serialVersionUID = " + serialVersionUID + "L;", (PsiElement)aClass);
        aClass.add((PsiElement)field);
    }
}

