/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class NoExplicitFinalizeCallsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "FinalizeCalledExplicitly";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("finalize.called.explicitly.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("finalize.called.explicitly.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoExplicitFinalizeCallsVisitor();
    }

    private static class NoExplicitFinalizeCallsVisitor
    extends BaseInspectionVisitor {
        private NoExplicitFinalizeCallsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, null, (PsiType)PsiType.VOID, "finalize", new PsiType[0])) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            if (MethodUtils.methodMatches(containingMethod, null, (PsiType)PsiType.VOID, "finalize", new PsiType[0])) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

