/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FinalizeCallsSuperFinalizeInspection
extends BaseInspection {
    public boolean ignoreObjectSubclasses = false;
    public boolean ignoreTrivialFinalizers = true;

    @NotNull
    public String getID() {
        return "FinalizeDoesntCallSuperFinalize";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("finalize.doesnt.call.super.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("finalize.doesnt.call.super.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("finalize.doesnt.call.super.ignore.option", new Object[0]), "ignoreObjectSubclasses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("ignore.trivial.finalizers.option", new Object[0]), "ignoreTrivialFinalizers");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoExplicitFinalizeCallsVisitor();
    }

    private class NoExplicitFinalizeCallsVisitor
    extends BaseInspectionVisitor {
        private NoExplicitFinalizeCallsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            String methodName = method.getName();
            if (!"finalize".equals(methodName)) {
                return;
            }
            if (method.hasModifierProperty("native") || method.hasModifierProperty("abstract")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (FinalizeCallsSuperFinalizeInspection.this.ignoreObjectSubclasses && (superClass = containingClass.getSuperClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            if (MethodCallUtils.containsSuperMethodCall("finalize", (PsiElement)method)) {
                return;
            }
            if (FinalizeCallsSuperFinalizeInspection.this.ignoreTrivialFinalizers && MethodUtils.isTrivial(method, false)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

