/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ThrowsRuntimeExceptionInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("throws.runtime.exception.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("throws.runtime.exception.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowsRuntimeExceptionVisitor();
    }

    private static class ThrowsRuntimeExceptionVisitor
    extends BaseInspectionVisitor {
        private ThrowsRuntimeExceptionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiJavaCodeReferenceElement[] referenceElements;
            super.visitMethod(method);
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = throwsList.getReferenceElements()) {
                PsiClass aClass;
                PsiElement target = referenceElement.resolve();
                if (!(target instanceof PsiClass) || !InheritanceUtil.isInheritor((PsiClass)(aClass = (PsiClass)target), (String)"java.lang.RuntimeException")) continue;
                String className = aClass.getName();
                this.registerError((PsiElement)referenceElement, className, referenceElement);
            }
        }
    }
}

