/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowFromFinallyBlockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("throw.from.finally.block.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            return InspectionGadgetsBundle.message("throw.from.finally.block.problem.descriptor", new Object[0]);
        }
        PsiClassType type = (PsiClassType)infos[0];
        return InspectionGadgetsBundle.message("possible.throw.from.finally.block.problem.descriptor", type.getPresentableText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowFromFinallyBlockVisitor();
    }

    private static PsiCodeBlock getContainingFinallyBlock(@NotNull PsiElement element, @NotNull PsiType thrownType) {
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                return finallyBlock;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)tryStatement.getTryBlock(), (PsiElement)currentElement, (boolean)true) && ThrowFromFinallyBlockInspection.isCaught(tryStatement, thrownType)) {
                return null;
            }
            currentElement = tryStatement;
        }
        return null;
    }

    private static boolean isCaught(PsiTryStatement tryStatement, PsiType exceptionType) {
        for (PsiParameter parameter : tryStatement.getCatchBlockParameters()) {
            PsiType type = parameter.getType();
            if (!type.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static class ThrowFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ThrowFromFinallyBlockVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions((PsiElement)expression);
            if (exceptions.isEmpty()) {
                return;
            }
            for (PsiClassType exception : exceptions) {
                PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock((PsiElement)expression, (PsiType)exception);
                if (finallyBlock == null || !ThrowFromFinallyBlockVisitor.isHidingOfPreviousException(finallyBlock, (PsiElement)expression)) continue;
                this.registerMethodCallError(expression, exception);
                return;
            }
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            super.visitThrowStatement(statement2);
            PsiExpression exception = ParenthesesUtils.stripParentheses(statement2.getException());
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type == null) {
                return;
            }
            PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock((PsiElement)statement2, type);
            if (finallyBlock == null) {
                return;
            }
            if (exception instanceof PsiReferenceExpression && ((target = (referenceExpression = (PsiReferenceExpression)exception).resolve()) == null || !PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)target, (boolean)true))) {
                return;
            }
            if (ThrowFromFinallyBlockVisitor.isHidingOfPreviousException(finallyBlock, (PsiElement)statement2)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
            }
        }

        private static boolean isHidingOfPreviousException(PsiCodeBlock finallyBlock, PsiElement throwElement) {
            PsiElement parent = finallyBlock.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return false;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
            if (catchBlocks.length == 0) {
                return true;
            }
            PsiIfStatement ifStatement = ThrowFromFinallyBlockVisitor.getParentOfType(throwElement, PsiIfStatement.class, (PsiElement)finallyBlock);
            if (ifStatement == null) {
                return true;
            }
            boolean inThenBranch = PsiTreeUtil.isAncestor((PsiElement)ifStatement.getThenBranch(), (PsiElement)throwElement, (boolean)false);
            boolean inElseBranch = PsiTreeUtil.isAncestor((PsiElement)ifStatement.getElseBranch(), (PsiElement)throwElement, (boolean)false);
            if (!inThenBranch && !inElseBranch) {
                return true;
            }
            PsiExpression condition = ifStatement.getCondition();
            PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(condition, inThenBranch);
            if (variable == null) {
                return true;
            }
            boolean assigned = true;
            for (PsiCodeBlock catchBlock : catchBlocks) {
                assigned &= VariableAccessUtils.variableIsAssigned(variable, (PsiElement)catchBlock);
            }
            return !assigned;
        }

        @Nullable
        public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, @NotNull PsiElement stopAt) {
            if (element == null || element instanceof PsiFile) {
                return null;
            }
            for (element = element.getParent(); element != null && !aClass.isInstance(element); element = element.getParent()) {
                if (element != stopAt && !(element instanceof PsiFile)) continue;
                return null;
            }
            return (T)element;
        }
    }
}

