/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.NestedSynchronizedStatementInspection;
import org.jetbrains.annotations.NotNull;

public class NestedTryStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("nested.try.statement.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("nested.try.statement.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedTryStatementVisitor();
    }

    private static class NestedTryStatementVisitor
    extends BaseInspectionVisitor {
        private NestedTryStatementVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            super.visitTryStatement(statement2);
            PsiTryStatement parentTry = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiTryStatement.class);
            if (parentTry == null) {
                return;
            }
            PsiCodeBlock tryBlock = parentTry.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)statement2, (boolean)true)) {
                return;
            }
            if (NestedSynchronizedStatementInspection.isNestedStatement(statement2, PsiTryStatement.class)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
            }
        }
    }
}

