/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTryStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class FinallyBlockCannotCompleteNormallyInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "finally";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("finally.block.cannot.complete.normally.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("finally.block.cannot.complete.normally.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinallyBlockCannotCompleteNormallyVisitor();
    }

    private static class FinallyBlockCannotCompleteNormallyVisitor
    extends BaseInspectionVisitor {
        private FinallyBlockCannotCompleteNormallyVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            PsiElement[] children2;
            super.visitTryStatement(statement2);
            PsiCodeBlock finallyBlock = statement2.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
                return;
            }
            for (PsiElement child : children2 = statement2.getChildren()) {
                String childText = child.getText();
                if (!"finally".equals(childText)) continue;
                this.registerError(child, new Object[0]);
                return;
            }
        }
    }
}

