/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BadExceptionDeclaredInspectionBase
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.Throwable", "java.lang.Exception", "java.lang.Error", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ClassCastException", "java.lang.ArrayIndexOutOfBoundsException");
    public boolean ignoreTestCases = false;
    public boolean ignoreLibraryOverrides = false;

    public BadExceptionDeclaredInspectionBase() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List strings = StringUtil.split((String)this.exceptionsString, (String)",");
            for (String string : strings) {
                this.exceptions.add(string);
            }
            this.exceptionsString = "";
        }
    }

    @NotNull
    public String getID() {
        return "ProhibitedExceptionDeclared";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("bad.exception.declared.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("bad.exception.declared.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionDeclaredVisitor();
    }

    private class BadExceptionDeclaredVisitor
    extends BaseInspectionVisitor {
        private BadExceptionDeclaredVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiJavaCodeReferenceElement[] references;
            super.visitMethod(method);
            if (BadExceptionDeclaredInspectionBase.this.ignoreLibraryOverrides && LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
                PsiClass thrownClass;
                String qualifiedName;
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiClass) || (qualifiedName = (thrownClass = (PsiClass)element).getQualifiedName()) == null || !BadExceptionDeclaredInspectionBase.this.exceptions.contains(qualifiedName)) continue;
                this.registerError((PsiElement)reference, reference);
            }
        }
    }
}

