/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BadExceptionCaughtInspectionBase
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.NullPointerException", "java.lang.IllegalMonitorStateException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.IndexOutOfBoundsException", "java.util.ConcurrentModificationException");

    public BadExceptionCaughtInspectionBase() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List strings = StringUtil.split((String)this.exceptionsString, (String)",");
            for (String string : strings) {
                this.exceptions.add(string);
            }
            this.exceptionsString = "";
        }
    }

    @NotNull
    public String getID() {
        return "ProhibitedExceptionCaught";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("bad.exception.caught.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("bad.exception.caught.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionCaughtVisitor();
    }

    private class BadExceptionCaughtVisitor
    extends BaseInspectionVisitor {
        private BadExceptionCaughtVisitor() {
        }

        public void visitCatchSection(PsiCatchSection section) {
            super.visitCatchSection(section);
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiTypeElement[] childTypeElements = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
            if (childTypeElements != null) {
                for (PsiTypeElement childTypeElement : childTypeElements) {
                    this.checkTypeElement(childTypeElement);
                }
            } else {
                this.checkTypeElement(typeElement);
            }
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            PsiType type = typeElement.getType();
            if (BadExceptionCaughtInspectionBase.this.exceptions.contains(type.getCanonicalText())) {
                this.registerError((PsiElement)typeElement, typeElement);
            }
        }
    }
}

