/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnOfDateFieldInspection
extends BaseInspection {
    public boolean ignorePrivateMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("return.date.calendar.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        return InspectionGadgetsBundle.message("return.date.calendar.field.problem.descriptor", type);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("return.of.null.ignore.private.option", new Object[0]), (InspectionProfileEntry)this, "ignorePrivateMethods");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReturnOfDateFieldFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfDateFieldVisitor();
    }

    private class ReturnOfDateFieldVisitor
    extends BaseInspectionVisitor {
        private ReturnOfDateFieldVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
            super.visitReturnStatement(statement2);
            PsiExpression returnValue = statement2.getReturnValue();
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement containingElement = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClass.class});
            if (containingElement == null || containingElement instanceof PsiClass || containingElement instanceof PsiMethod && ReturnOfDateFieldInspection.this.ignorePrivateMethods && ((PsiMethod)containingElement).hasModifierProperty("private")) {
                return;
            }
            PsiReferenceExpression fieldReference = (PsiReferenceExpression)returnValue;
            PsiElement element = fieldReference.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(returnValue, "java.util.Date", "java.util.Calendar");
            if (type == null) {
                return;
            }
            this.registerError((PsiElement)returnValue, type);
        }
    }

    private static class ReturnOfDateFieldFix
    extends InspectionGadgetsFix {
        private final String myType;

        public ReturnOfDateFieldFix(String type) {
            this.myType = type;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("return.date.calendar.field.quickfix", this.myType);
        }

        @NotNull
        public String getFamilyName() {
            return "Return clone";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String type = TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Date", "java.util.Calendar");
            if (type == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, '(' + type + ')' + referenceExpression.getText() + ".clone()");
        }
    }
}

