/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnOfCollectionFieldInspectionBase
extends BaseInspection {
    public boolean ignorePrivateMethods = true;

    @NotNull
    public String getID() {
        return "ReturnOfCollectionOrArrayField";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("return.of.collection.array.field.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("return.of.collection.array.field.option", new Object[0]), (InspectionProfileEntry)this, "ignorePrivateMethods");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        PsiType type = field.getType();
        if (type instanceof PsiArrayType) {
            return InspectionGadgetsBundle.message("return.of.collection.array.field.problem.descriptor.array", new Object[0]);
        }
        return InspectionGadgetsBundle.message("return.of.collection.array.field.problem.descriptor.collection", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfCollectionFieldVisitor();
    }

    private class ReturnOfCollectionFieldVisitor
    extends BaseInspectionVisitor {
        private ReturnOfCollectionFieldVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
            super.visitReturnStatement(statement2);
            PsiExpression returnValue = statement2.getReturnValue();
            if (returnValue == null) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (element == null) {
                return;
            }
            if (ReturnOfCollectionFieldInspectionBase.this.ignorePrivateMethods && element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("private")) {
                return;
            }
            PsiClass returnStatementClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiClass.class);
            if (returnStatementClass == null) {
                return;
            }
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)returnValue;
            PsiElement referent = referenceExpression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (!returnStatementClass.equals(fieldClass)) {
                return;
            }
            if (!CollectionUtils.isArrayOrCollectionField(field)) {
                return;
            }
            this.registerError((PsiElement)returnValue, field, returnValue);
        }
    }
}

