/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtectedInnerClassInspectionBase
extends BaseInspection {
    public boolean ignoreEnums = false;
    public boolean ignoreInterfaces = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("protected.inner.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("protected.inner.class.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("protected.inner.class.ignore.enum.option", new Object[0]), "ignoreEnums");
        panel.addCheckbox(InspectionGadgetsBundle.message("protected.inner.class.ignore.interface.option", new Object[0]), "ignoreInterfaces");
        return panel;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedInnerClassVisitor();
    }

    private class ProtectedInnerClassVisitor
    extends BaseInspectionVisitor {
        private ProtectedInnerClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!aClass.hasModifierProperty("protected")) {
                return;
            }
            if (!ClassUtils.isInnerClass(aClass)) {
                return;
            }
            if (ProtectedInnerClassInspectionBase.this.ignoreEnums && aClass.isEnum()) {
                return;
            }
            if (ProtectedInnerClassInspectionBase.this.ignoreInterfaces && aClass.isInterface()) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

