/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.dataflow.ScopeUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooBroadScopeInspectionBase
extends BaseInspection {
    public boolean m_allowConstructorAsInitializer = false;
    public boolean m_onlyLookAtBlocks = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("too.broad.scope.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "TooBroadScope";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel checkboxOptionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.only.blocks.option", new Object[0]), "m_onlyLookAtBlocks");
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.allow.option", new Object[0]), "m_allowConstructorAsInitializer");
        return checkboxOptionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("too.broad.scope.problem.descriptor", new Object[0]);
    }

    protected boolean isMoveable(PsiExpression expression) {
        if (expression == null) {
            return true;
        }
        if (PsiUtil.isConstantExpression((PsiExpression)expression) || ExpressionUtils.isNullLiteral(expression)) {
            return true;
        }
        if (expression instanceof PsiNewExpression) {
            PsiExpression[] expressions;
            PsiExpressionList argumentList;
            PsiType type;
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
            if (arrayDimensions.length > 0) {
                for (PsiExpression arrayDimension : arrayDimensions) {
                    if (this.isMoveable(arrayDimension)) continue;
                    return false;
                }
                return true;
            }
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            boolean result = true;
            if (arrayInitializer != null) {
                PsiExpression[] initializers;
                for (PsiExpression initializerExpression : initializers = arrayInitializer.getInitializers()) {
                    result &= this.isMoveable(initializerExpression);
                }
            } else if (!this.m_allowConstructorAsInitializer && !ClassUtils.isImmutable(type = newExpression.getType())) {
                return false;
            }
            if ((argumentList = newExpression.getArgumentList()) == null) {
                return result;
            }
            for (PsiExpression argumentExpression : expressions = argumentList.getExpressions()) {
                result &= this.isMoveable(argumentExpression);
            }
            return result;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)target;
            if (ExpressionUtils.isConstant(field)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadScopeVisitor();
    }

    private class TooBroadScopeVisitor
    extends BaseInspectionVisitor {
        private TooBroadScopeVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            if (!(variable instanceof PsiLocalVariable) || variable instanceof PsiResourceVariable) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (!TooBroadScopeInspectionBase.this.isMoveable(initializer)) {
                return;
            }
            PsiElement variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
            if (variableScope == null) {
                return;
            }
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope());
            Collection referencesCollection = query.findAll();
            int size = referencesCollection.size();
            if (size == 0) {
                return;
            }
            PsiElement[] referenceElements = new PsiElement[referencesCollection.size()];
            int index = 0;
            for (PsiReference reference : referencesCollection) {
                PsiElement referenceElement;
                referenceElements[index] = referenceElement = reference.getElement();
                ++index;
            }
            PsiElement commonParent = ScopeUtils.getCommonParent(referenceElements);
            if (commonParent == null) {
                return;
            }
            if (initializer != null && (commonParent = ScopeUtils.moveOutOfLoopsAndClasses(commonParent, variableScope)) == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)commonParent, (PsiElement)variableScope, (boolean)true)) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)variableScope, (PsiElement)commonParent, (boolean)true)) {
                this.registerVariableError(variable, variable);
                return;
            }
            if (TooBroadScopeInspectionBase.this.m_onlyLookAtBlocks) {
                return;
            }
            if (commonParent instanceof PsiForStatement) {
                return;
            }
            PsiElement referenceElement = referenceElements[0];
            PsiElement blockChild = ScopeUtils.getChildWhichContainsElement(variableScope, referenceElement);
            if (blockChild == null) {
                return;
            }
            PsiElement insertionPoint = ScopeUtils.findTighterDeclarationLocation(blockChild, variable);
            if (insertionPoint == null) {
                if (!(blockChild instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)blockChild;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQ) {
                    return;
                }
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!lhs.equals(referenceElement)) {
                    return;
                }
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                    return;
                }
            }
            if (insertionPoint != null && FileTypeUtils.isInServerPageFile((PsiElement)insertionPoint)) {
                PsiElement variableParent;
                PsiElement elementBefore = insertionPoint.getPrevSibling();
                if ((elementBefore = PsiTreeUtil.skipSiblingsBackward((PsiElement)elementBefore, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiDeclarationStatement && elementBefore.equals(variableParent = variable.getParent())) {
                    return;
                }
            }
            this.registerVariableError(variable, variable);
        }
    }
}

