/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantValueVariableUseInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("constant.value.variable.use.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.value.variable.use.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new ReplaceReferenceWithExpressionFix(expression.getText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantValueVariableUseVisitor();
    }

    private static class VariableReadVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiVariable variable;
        private boolean read = false;
        private boolean stop = false;
        private PsiReferenceExpression reference = null;

        VariableReadVisitor(@NotNull PsiVariable variable) {
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.read || this.stop) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.read || this.stop) {
                return;
            }
            PsiElement target = expression.resolve();
            if (this.variable.equals(target)) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                    this.stop = true;
                    return;
                }
                if (PsiUtil.isAccessedForReading((PsiExpression)expression)) {
                    if (VariableReadVisitor.isInLoopCondition((PsiExpression)expression)) {
                        this.stop = true;
                    } else {
                        this.reference = expression;
                        this.read = true;
                    }
                    return;
                }
            }
            super.visitReferenceExpression(expression);
        }

        private static boolean isInLoopCondition(PsiExpression expression) {
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            return statement2 instanceof PsiLoopStatement;
        }

        public boolean isRead() {
            return this.read;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }
    }

    private static class ConstantValueVariableUseVisitor
    extends BaseInspectionVisitor {
        private ConstantValueVariableUseVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            PsiStatement body = statement2.getThenBranch();
            this.checkCondition(condition, body);
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            PsiStatement body = statement2.getBody();
            this.checkCondition(condition, body);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            PsiStatement body = statement2.getBody();
            this.checkCondition(condition, body);
        }

        private boolean checkCondition(@Nullable PsiExpression condition, @Nullable PsiStatement body) {
            if (body == null) {
                return false;
            }
            if (!(condition instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND == tokenType) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!this.checkCondition(operand, body)) continue;
                    return true;
                }
                return false;
            }
            if (JavaTokenType.EQEQ != tokenType) {
                return false;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length != 2) {
                return false;
            }
            PsiExpression lhs = operands[0];
            PsiExpression rhs = operands[1];
            if (PsiUtil.isConstantExpression((PsiExpression)lhs)) {
                return this.checkConstantValueVariableUse(rhs, lhs, (PsiElement)body);
            }
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return this.checkConstantValueVariableUse(lhs, rhs, (PsiElement)body);
            }
            return false;
        }

        private boolean checkConstantValueVariableUse(@Nullable PsiExpression expression, @NotNull PsiExpression constantExpression, @NotNull PsiElement body) {
            PsiType constantType = constantExpression.getType();
            if (PsiType.DOUBLE.equals((Object)constantType)) {
                Object result = ExpressionUtils.computeConstantExpression(constantExpression, false);
                if (Double.valueOf(0.0).equals(result) || Double.valueOf(-0.0).equals(result)) {
                    return false;
                }
            }
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            if (target instanceof PsiField) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            VariableReadVisitor visitor = new VariableReadVisitor(variable);
            body.accept((PsiElementVisitor)visitor);
            if (!visitor.isRead()) {
                return false;
            }
            this.registerError((PsiElement)visitor.getReference(), constantExpression);
            return true;
        }
    }

    private static class ReplaceReferenceWithExpressionFix
    extends InspectionGadgetsFix {
        private final String myText;

        ReplaceReferenceWithExpressionFix(String text) {
            this.myText = text;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("replace.reference.with.expression.quickfix", this.myText);
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression, this.myText);
        }
    }
}

