/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InitializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryDefaultInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.default.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.default.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryDefaultVisitor();
    }

    private static class UnnecessaryDefaultVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryDefaultVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            super.visitSwitchStatement(statement2);
            PsiSwitchLabelStatement defaultStatement = UnnecessaryDefaultVisitor.retrieveUnnecessaryDefault(statement2);
            if (defaultStatement == null) {
                return;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)defaultStatement, PsiStatement.class);
            while (nextStatement != null && !(nextStatement instanceof PsiBreakStatement) && !(nextStatement instanceof PsiSwitchLabelStatement)) {
                if (nextStatement instanceof PsiThrowStatement || UnnecessaryDefaultVisitor.isStatementNeededForInitializationOfVariable(statement2, nextStatement)) {
                    return;
                }
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            this.registerStatementError((PsiStatement)defaultStatement, new Object[0]);
        }

        private static boolean isStatementNeededForInitializationOfVariable(PsiSwitchStatement switchStatement, PsiStatement statement2) {
            if (!(statement2 instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiLocalVariable)) {
                return false;
            }
            PsiLocalVariable variable = (PsiLocalVariable)target;
            return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, (PsiVariable)variable, true);
        }

        @Nullable
        private static PsiSwitchLabelStatement retrieveUnnecessaryDefault(PsiSwitchStatement statement2) {
            PsiExpression expression = statement2.getExpression();
            if (expression == null) {
                return null;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null || !aClass.isEnum()) {
                return null;
            }
            PsiCodeBlock body = statement2.getBody();
            if (body == null) {
                return null;
            }
            PsiStatement[] statements = body.getStatements();
            int numCases = 0;
            PsiSwitchLabelStatement result = null;
            for (PsiStatement child : statements) {
                if (!(child instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)child;
                if (labelStatement.isDefaultCase()) {
                    result = labelStatement;
                    continue;
                }
                ++numCases;
            }
            if (result == null) {
                return null;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type)) continue;
                ++numEnums;
            }
            if (numEnums != numCases) {
                return null;
            }
            return result;
        }
    }
}

