/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementDensityInspection
extends BaseInspection {
    private static final int DEFAULT_DENSITY_LIMIT = 20;
    public int m_limit = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("switch.statement.density.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.density.min.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer intDensity = (Integer)infos[0];
        return InspectionGadgetsBundle.message("switch.statement.density.problem.descriptor", intDensity);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementDensityVisitor();
    }

    private static class StatementCountVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int statementCount;

        private StatementCountVisitor() {
        }

        public void visitStatement(@NotNull PsiStatement statement2) {
            super.visitStatement(statement2);
            if (statement2 instanceof PsiSwitchLabelStatement || statement2 instanceof PsiBreakStatement) {
                return;
            }
            ++this.statementCount;
        }

        int getStatementCount() {
            return this.statementCount;
        }
    }

    private class SwitchStatementDensityVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementDensityVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            PsiCodeBlock body = statement2.getBody();
            if (body == null) {
                return;
            }
            int branchCount = SwitchUtils.calculateBranchCount(statement2);
            if (branchCount == 0) {
                return;
            }
            double density = this.calculateDensity(body, branchCount);
            int intDensity = (int)(density * 100.0);
            if (intDensity > SwitchStatementDensityInspection.this.m_limit) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, intDensity);
        }

        private double calculateDensity(@NotNull PsiCodeBlock body, int branchCount) {
            StatementCountVisitor visitor = new StatementCountVisitor();
            body.accept((PsiElementVisitor)visitor);
            return (double)branchCount / (double)visitor.getStatementCount();
        }
    }
}

