/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NegatedConditionalInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("negated.conditional.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "ConditionalExpressionWithNegatedCondition";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("negated.conditional.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedConditionalVisitor();
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("negated.conditional.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreNegatedNullComparison");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedConditionalFix();
    }

    private class NegatedConditionalVisitor
    extends BaseInspectionVisitor {
        private NegatedConditionalVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression thenBranch = expression.getThenExpression();
            if (thenBranch == null) {
                return;
            }
            PsiExpression elseBranch = expression.getElseExpression();
            if (elseBranch == null) {
                return;
            }
            PsiExpression condition = expression.getCondition();
            if (!ExpressionUtils.isNegation(condition, NegatedConditionalInspection.this.m_ignoreNegatedNullComparison, false)) {
                return;
            }
            this.registerError((PsiElement)condition, new Object[0]);
        }
    }

    private static class NegatedConditionalFix
    extends InspectionGadgetsFix {
        private NegatedConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("negated.conditional.invert.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element.getParent();
            assert (conditionalExpression != null);
            PsiExpression elseBranch = conditionalExpression.getElseExpression();
            PsiExpression thenBranch = conditionalExpression.getThenExpression();
            PsiExpression condition = conditionalExpression.getCondition();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition);
            assert (elseBranch != null);
            assert (thenBranch != null);
            String newStatement = negatedCondition + '?' + elseBranch.getText() + ':' + thenBranch.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)conditionalExpression, newStatement);
        }
    }
}

