/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopWithImplicitTerminationConditionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (Boolean.TRUE.equals(infos[0])) {
            return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.dowhile.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LoopWithImplicitTerminationConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopWithImplicitTerminationConditionVisitor();
    }

    static boolean containsUnlabeledBreakStatement(@Nullable PsiStatement statement2) {
        if (!(statement2 instanceof PsiBlockStatement)) {
            return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(statement2);
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(codeBlock);
        return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(firstStatement);
    }

    private static boolean isUnlabeledBreakStatement(@Nullable PsiStatement statement2) {
        if (!(statement2 instanceof PsiBreakStatement)) {
            return false;
        }
        PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
        PsiIdentifier identifier = breakStatement.getLabelIdentifier();
        return identifier == null;
    }

    private static class LoopWithImplicitTerminationConditionVisitor
    extends BaseInspectionVisitor {
        private LoopWithImplicitTerminationConditionVisitor() {
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition((PsiLoopStatement)statement2, true)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, Boolean.FALSE);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition((PsiLoopStatement)statement2, false)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, Boolean.TRUE);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition((PsiLoopStatement)statement2, true)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, Boolean.FALSE);
        }

        private static boolean isLoopWithImplicitTerminationCondition(PsiLoopStatement statement2, boolean firstStatement) {
            PsiStatement bodyStatement;
            PsiStatement body = statement2.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return true;
                }
                bodyStatement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                bodyStatement = body;
            }
            return !LoopWithImplicitTerminationConditionVisitor.isImplicitTerminationCondition(bodyStatement);
        }

        private static boolean isImplicitTerminationCondition(@Nullable PsiStatement statement2) {
            if (!(statement2 instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                return true;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch);
        }
    }

    private static class LoopWithImplicitTerminationConditionFix
    extends InspectionGadgetsFix {
        private LoopWithImplicitTerminationConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiStatement statement2;
            boolean firstStatement;
            PsiStatement body;
            PsiExpression loopCondition;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)parent;
                loopCondition = whileStatement.getCondition();
                body = whileStatement.getBody();
                firstStatement = true;
            } else if (parent instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)parent;
                loopCondition = doWhileStatement.getCondition();
                body = doWhileStatement.getBody();
                firstStatement = false;
            } else if (parent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent;
                loopCondition = forStatement.getCondition();
                body = forStatement.getBody();
                firstStatement = true;
            } else {
                return;
            }
            if (loopCondition == null) {
                return;
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return;
                }
                statement2 = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                statement2 = body;
            }
            if (!(statement2 instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            PsiExpression ifCondition = ifStatement.getCondition();
            if (ifCondition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                String negatedExpressionText = BoolUtils.getNegatedExpressionText(ifCondition);
                PsiReplacementUtil.replaceExpression(loopCondition, negatedExpressionText);
                LoopWithImplicitTerminationConditionFix.replaceStatement((PsiStatement)ifStatement, elseBranch);
            } else if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch)) {
                loopCondition.replace((PsiElement)ifCondition);
                if (thenBranch == null) {
                    ifStatement.delete();
                } else {
                    LoopWithImplicitTerminationConditionFix.replaceStatement((PsiStatement)ifStatement, thenBranch);
                }
            }
        }

        private static void replaceStatement(@NotNull PsiStatement replacedStatement, @Nullable PsiStatement replacingStatement) throws IncorrectOperationException {
            if (replacingStatement == null) {
                replacedStatement.delete();
                return;
            }
            if (!(replacingStatement instanceof PsiBlockStatement)) {
                replacedStatement.replace((PsiElement)replacingStatement);
                return;
            }
            PsiBlockStatement blockStatement = (PsiBlockStatement)replacingStatement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children2 = codeBlock.getChildren();
            if (children2.length > 2) {
                PsiElement receiver = replacedStatement.getParent();
                for (int i = children2.length - 2; i > 0; --i) {
                    PsiElement child = children2[i];
                    if (child instanceof PsiWhiteSpace) continue;
                    receiver.addAfter(child, (PsiElement)replacedStatement);
                }
                replacedStatement.delete();
            }
        }
    }
}

