/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.ConditionalReturnStatementValue;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfStatementWithIdenticalBranchesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("if.statement.with.identical.branches.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("if.statement.with.identical.branches.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseIfFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithIdenticalBranchesVisitor();
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            super.visitIfStatement(ifStatement);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            Project project2 = ifStatement.getProject();
            InputVariables inputVariables = new InputVariables(Collections.emptyList(), project2, new LocalSearchScope((PsiElement)thenBranch), false);
            DuplicatesFinder finder = new DuplicatesFinder(new PsiElement[]{thenBranch}, inputVariables, null, Collections.emptyList());
            if (elseBranch instanceof PsiIfStatement) {
                PsiIfStatement statement2 = (PsiIfStatement)elseBranch;
                PsiStatement branch = statement2.getThenBranch();
                if (branch == null) {
                    return;
                }
                Match match = finder.isDuplicate((PsiElement)branch, true);
                if (match != null) {
                    ReturnValue matchReturnValue = match.getReturnValue();
                    if (matchReturnValue instanceof ConditionalReturnStatementValue && !matchReturnValue.isEquivalent(this.buildReturnValue((PsiElement)thenBranch))) {
                        return;
                    }
                    this.registerStatementError((PsiStatement)ifStatement, statement2);
                    return;
                }
            }
            if (elseBranch == null) {
                this.checkIfStatementWithoutElseBranch(ifStatement);
            } else {
                Match match = finder.isDuplicate((PsiElement)elseBranch, true);
                if (match != null) {
                    ReturnValue matchReturnValue = match.getReturnValue();
                    if (matchReturnValue instanceof ConditionalReturnStatementValue && !matchReturnValue.isEquivalent(this.buildReturnValue((PsiElement)thenBranch))) {
                        return;
                    }
                    this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                }
            }
        }

        @Nullable
        private ReturnValue buildReturnValue(PsiElement element) {
            final Ref result = Ref.create(null);
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                }

                public void visitReturnStatement(PsiReturnStatement statement2) {
                    super.visitReturnStatement(statement2);
                    result.set((Object)statement2);
                }
            });
            PsiReturnStatement returnStatement = (PsiReturnStatement)result.get();
            if (returnStatement == null) {
                return null;
            }
            PsiExpression expression = returnStatement.getReturnValue();
            if (expression == null) {
                return null;
            }
            return new ConditionalReturnStatementValue(expression);
        }

        private void checkIfStatementWithoutElseBranch(PsiIfStatement ifStatement) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            PsiStatement nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement((PsiStatement)ifStatement);
            if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                PsiStatement lastStatement = statements[statements.length - 1];
                for (PsiStatement statement2 : statements) {
                    if (nextStatement == null) {
                        PsiReturnStatement returnStatement;
                        if (statement2 == lastStatement && statement2 instanceof PsiReturnStatement && (returnStatement = (PsiReturnStatement)statement2).getReturnValue() == null) {
                            this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                        }
                        return;
                    }
                    if (!EquivalenceChecker.statementsAreEquivalent(statement2, nextStatement)) {
                        return;
                    }
                    nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement(nextStatement);
                }
            } else if (!EquivalenceChecker.statementsAreEquivalent(thenBranch, nextStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
        }

        @Nullable
        private static PsiStatement getNextStatement(PsiStatement statement2) {
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
            while (nextStatement == null) {
                PsiElement nextStatementParent;
                PsiElement statementParent;
                if ((statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiStatement.class)) == null) {
                    return null;
                }
                if (statement2 instanceof PsiLoopStatement) {
                    return statement2;
                }
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
                if (nextStatement == null || !((statementParent = statement2.getParent()) instanceof PsiIfStatement) || !statementParent.equals(nextStatementParent = nextStatement.getParent())) continue;
                nextStatement = null;
            }
            return nextStatement;
        }
    }

    private static class CollapseIfFix
    extends InspectionGadgetsFix {
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("if.statement.with.identical.branches.collapse.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement identifier = descriptor.getPsiElement();
            PsiIfStatement statement2 = (PsiIfStatement)identifier.getParent();
            assert (statement2 != null);
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement2.getElseBranch();
            if (elseBranch == null) {
                statement2.delete();
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                PsiIfStatement elseIfStatement = (PsiIfStatement)elseBranch;
                PsiExpression condition1 = statement2.getCondition();
                PsiExpression condition2 = elseIfStatement.getCondition();
                if (condition1 == null) {
                    return;
                }
                PsiReplacementUtil.replaceExpression(condition1, CollapseIfFix.buildOrExpressionText(condition1, condition2));
                PsiStatement elseElseBranch = elseIfStatement.getElseBranch();
                if (elseElseBranch == null) {
                    elseIfStatement.delete();
                } else {
                    elseIfStatement.replace((PsiElement)elseElseBranch);
                }
            } else {
                PsiElement parent = statement2.getParent();
                if (thenBranch instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                    if (parent instanceof PsiCodeBlock) {
                        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                        PsiStatement[] statements = codeBlock.getStatements();
                        if (statements.length > 0) {
                            parent.addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)statement2);
                        }
                        statement2.delete();
                    } else {
                        statement2.replace((PsiElement)blockStatement);
                    }
                } else {
                    statement2.replace((PsiElement)thenBranch);
                }
            }
        }

        private static String buildOrExpressionText(PsiExpression expression1, PsiExpression expression2) {
            StringBuilder result = new StringBuilder();
            if (expression1 != null) {
                result.append(expression1.getText());
            }
            result.append("||");
            if (expression2 != null) {
                result.append(expression2.getText());
            }
            return result.toString();
        }
    }
}

