/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForLoopWithMissingComponentInspection
extends BaseInspection {
    public boolean ignoreCollectionLoops = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("for.loop.with.missing.component.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasInitializer = (Boolean)infos[0];
        boolean hasCondition = (Boolean)infos[1];
        boolean hasUpdate = (Boolean)infos[2];
        if (hasInitializer) {
            if (hasCondition) {
                return InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor3", new Object[0]);
            }
            if (hasUpdate) {
                return InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor2", new Object[0]);
            }
            return InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor6", new Object[0]);
        }
        if (hasCondition) {
            if (hasUpdate) {
                return InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor1", new Object[0]);
            }
            return InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor5", new Object[0]);
        }
        if (hasUpdate) {
            return InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor4", new Object[0]);
        }
        return InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor7", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("for.loop.with.missing.component.collection.loop.option", new Object[0]), (InspectionProfileEntry)this, "ignoreCollectionLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopWithMissingComponentVisitor();
    }

    private class ForLoopWithMissingComponentVisitor
    extends BaseInspectionVisitor {
        private ForLoopWithMissingComponentVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            super.visitForStatement(statement2);
            boolean hasCondition = this.hasCondition(statement2);
            boolean hasInitializer = this.hasInitializer(statement2);
            boolean hasUpdate = this.hasUpdate(statement2);
            if (hasCondition && hasInitializer && hasUpdate) {
                return;
            }
            if (ForLoopWithMissingComponentInspection.this.ignoreCollectionLoops && this.isCollectionLoopStatement(statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, hasInitializer, hasCondition, hasUpdate);
        }

        private boolean hasCondition(PsiForStatement statement2) {
            return statement2.getCondition() != null;
        }

        private boolean hasInitializer(PsiForStatement statement2) {
            PsiStatement initialization = statement2.getInitialization();
            return initialization != null && !(initialization instanceof PsiEmptyStatement);
        }

        private boolean hasUpdate(PsiForStatement statement2) {
            PsiStatement update = statement2.getUpdate();
            return update != null && !(update instanceof PsiEmptyStatement);
        }

        private boolean isCollectionLoopStatement(PsiForStatement forStatement) {
            PsiElement[] declaredElements;
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            for (PsiElement declaredElement : declaredElements = declaration.getDeclaredElements()) {
                PsiExpression condition;
                if (!(declaredElement instanceof PsiVariable)) continue;
                PsiVariable variable = (PsiVariable)declaredElement;
                if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator") || !this.isHasNext(condition = forStatement.getCondition(), variable)) continue;
                return true;
            }
            return false;
        }

        private boolean isHasNext(PsiExpression condition, PsiVariable iterator) {
            if (condition instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                return this.isHasNext(lhs, iterator) || this.isHasNext(rhs, iterator);
            }
            if (!(condition instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)condition;
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"hasNext".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            return iterator.equals(target);
        }
    }
}

