/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallthruInSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("fallthru.in.switch.statement.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "fallthrough";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("fallthru.in.switch.statement.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new FallthruInSwitchStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FallthroughInSwitchStatementVisitor();
    }

    private static class FallthroughInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*thro?u");

        private FallthroughInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement switchStatement) {
            super.visitSwitchStatement(switchStatement);
            PsiCodeBlock body = switchStatement.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            for (int i = 1; i < statements.length; ++i) {
                PsiStatement previousStatement;
                PsiComment comment;
                String commentText;
                PsiElement previousSibling;
                PsiStatement statement2 = statements[i];
                if (!(statement2 instanceof PsiSwitchLabelStatement) || (previousSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiComment && commentPattern.matcher(commentText = (comment = (PsiComment)previousSibling).getText()).find() || (previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement2, PsiStatement.class)) instanceof PsiSwitchLabelStatement || !ControlFlowUtils.statementMayCompleteNormally(previousStatement)) continue;
                this.registerError((PsiElement)statement2, new Object[0]);
            }
        }
    }

    private static class FallthruInSwitchStatementFix
    extends InspectionGadgetsFix {
        private FallthruInSwitchStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("fallthru.in.switch.statement.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)descriptor.getPsiElement();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiStatement breakStatement = factory.createStatementFromText("break;", (PsiElement)labelStatement);
            PsiElement parent = labelStatement.getParent();
            parent.addBefore((PsiElement)breakStatement, (PsiElement)labelStatement);
        }
    }
}

