/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateConditionInspection
extends BaseInspection {
    public boolean ignoreMethodCalls = false;
    private static final int LIMIT_DEPTH = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("duplicate.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("duplicate.condition.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), (InspectionProfileEntry)this, "ignoreMethodCalls");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    private class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private DuplicateConditionVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            if (ControlFlowUtils.isElseIf(statement2)) {
                return;
            }
            HashSet<PsiExpression> conditions = new HashSet<PsiExpression>();
            this.collectConditionsForIfStatement(statement2, conditions, 0);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            PsiExpression[] conditionArray = conditions.toArray(new PsiExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            for (int i = 0; i < conditionArray.length; ++i) {
                if (matched[i]) continue;
                PsiExpression condition = conditionArray[i];
                for (int j = i + 1; j < conditionArray.length; ++j) {
                    PsiExpression testCondition;
                    boolean areEquivalent;
                    if (matched[j] || !(areEquivalent = EquivalenceChecker.expressionsAreEquivalent(condition, testCondition = conditionArray[j]))) continue;
                    if (!DuplicateConditionInspection.this.ignoreMethodCalls || !this.containsMethodCallExpression((PsiElement)testCondition)) {
                        this.registerError((PsiElement)testCondition, new Object[0]);
                        if (!matched[i]) {
                            this.registerError((PsiElement)condition, new Object[0]);
                        }
                    }
                    matched[i] = true;
                    matched[j] = true;
                }
            }
        }

        private void collectConditionsForIfStatement(PsiIfStatement statement2, Set<PsiExpression> conditions, int depth) {
            if (depth > 20) {
                return;
            }
            PsiExpression condition = statement2.getCondition();
            this.collectConditionsForExpression(condition, conditions);
            PsiStatement branch = statement2.getElseBranch();
            if (branch instanceof PsiIfStatement) {
                this.collectConditionsForIfStatement((PsiIfStatement)branch, conditions, depth + 1);
            }
        }

        private void collectConditionsForExpression(PsiExpression condition, Set<PsiExpression> conditions) {
            PsiPolyadicExpression polyadicExpression;
            IElementType tokenType;
            if (condition == null) {
                return;
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                PsiExpression contents = parenthesizedExpression.getExpression();
                this.collectConditionsForExpression(contents, conditions);
                return;
            }
            if (condition instanceof PsiPolyadicExpression && JavaTokenType.OROR.equals(tokenType = (polyadicExpression = (PsiPolyadicExpression)condition).getOperationTokenType())) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    this.collectConditionsForExpression(operand, conditions);
                }
                return;
            }
            conditions.add(condition);
        }

        private boolean containsMethodCallExpression(PsiElement element) {
            PsiElement[] children2;
            if (element instanceof PsiMethodCallExpression) {
                return true;
            }
            for (PsiElement child : children2 = element.getChildren()) {
                if (!this.containsMethodCallExpression(child)) continue;
                return true;
            }
            return false;
        }
    }
}

