/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ContinueStatementWithLabelInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("continue.statement.with.label.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("continue.statement.with.label.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ContinueStatementWithLabelVisitor();
    }

    private static class ContinueStatementWithLabelVisitor
    extends BaseInspectionVisitor {
        private ContinueStatementWithLabelVisitor() {
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement2) {
            super.visitContinueStatement(statement2);
            PsiIdentifier label = statement2.getLabelIdentifier();
            if (label == null) {
                return;
            }
            String labelText = label.getText();
            if (labelText == null) {
                return;
            }
            if (labelText.length() == 0) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }
}

