/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfusingElseInspection
extends BaseInspection {
    public boolean reportWhenNoStatementFollow = false;

    @NotNull
    public String getID() {
        return "ConfusingElseBranch";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("confusing.else.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("confusing.else.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("confusing.else.option", new Object[0]), (InspectionProfileEntry)this, "reportWhenNoStatementFollow");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingElseVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConfusingElseFix();
    }

    private class ConfusingElseVisitor
    extends BaseInspectionVisitor {
        private ConfusingElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            PsiKeyword elseToken;
            super.visitIfStatement(statement2);
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement2.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            if (!ConfusingElseInspection.this.reportWhenNoStatementFollow) {
                PsiStatement nextStatement = this.getNextStatement(statement2);
                if (nextStatement == null) {
                    return;
                }
                if (!ControlFlowUtils.statementMayCompleteNormally(elseBranch)) {
                    return;
                }
            }
            if ((elseToken = statement2.getElseElement()) == null) {
                return;
            }
            if (this.parentCompletesNormally((PsiElement)statement2)) {
                return;
            }
            this.registerError((PsiElement)elseToken, new Object[0]);
        }

        private boolean parentCompletesNormally(PsiElement element) {
            PsiElement parent = element.getParent();
            while (parent instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch != element) {
                    return true;
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                    return true;
                }
                element = parent;
                parent = element.getParent();
            }
            return !(parent instanceof PsiCodeBlock);
        }

        @Nullable
        private PsiStatement getNextStatement(PsiIfStatement statement2) {
            PsiIfStatement parentIfStatement;
            PsiStatement elseBranch;
            PsiElement parent;
            while ((parent = statement2.getParent()) instanceof PsiIfStatement && (elseBranch = (parentIfStatement = (PsiIfStatement)parent).getElseBranch()) == statement2) {
                statement2 = parentIfStatement;
            }
            return (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
        }
    }

    private static class ConfusingElseFix
    extends InspectionGadgetsFix {
        private ConfusingElseFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("confusing.else.unwrap.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)ifKeyword.getParent();
            if (ifStatement == null) {
                return;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiIfStatement anchor = ifStatement;
            PsiElement parent = anchor.getParent();
            while (parent instanceof PsiIfStatement) {
                anchor = parent;
                parent = anchor.getParent();
            }
            if (elseBranch instanceof PsiBlockStatement) {
                PsiBlockStatement elseBlock = (PsiBlockStatement)elseBranch;
                PsiCodeBlock block = elseBlock.getCodeBlock();
                PsiElement[] children2 = block.getChildren();
                if (children2.length > 2) {
                    parent.addRangeAfter(children2[1], children2[children2.length - 2], (PsiElement)anchor);
                }
            } else {
                parent.addAfter((PsiElement)elseBranch, (PsiElement)anchor);
            }
            elseBranch.delete();
        }
    }
}

