/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class BreakStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("break.statement.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("statement.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BreakStatementVisitor();
    }

    private static class BreakStatementVisitor
    extends BaseInspectionVisitor {
        private BreakStatementVisitor() {
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement2) {
            super.visitBreakStatement(statement2);
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiSwitchStatement.class);
            if (switchStatement != null && BreakStatementVisitor.isTopLevelBreakInSwitch(statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        private static boolean isTopLevelBreakInSwitch(PsiBreakStatement statement2) {
            PsiElement parent = statement2.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return false;
            }
            PsiElement parentsParent = parent.getParent();
            if (parentsParent instanceof PsiSwitchStatement) {
                return true;
            }
            if (!(parentsParent instanceof PsiBlockStatement)) {
                return false;
            }
            PsiElement blocksParent = parentsParent.getParent();
            if (!(blocksParent instanceof PsiCodeBlock)) {
                return false;
            }
            PsiElement blocksParentsParent = blocksParent.getParent();
            return blocksParentsParent instanceof PsiSwitchStatement;
        }
    }
}

